function Figure7C()
% This script generates the plots in Figure 7C. The file Figure7C_data.mat
% contains simulation results for three lattice types (hexagonal,
% square-diagonal and square-upright) and three different epitope spacings
% (8, 10, and 12 nm).

load('Figure7C_data.mat');

figure;
loglog(a,hex,'k'); hold on;
xlim([0 1000]); title('Hexagonal');
xlabel('Filament radius (nm)');
ylabel('Fraction IgG hexamers');
axis square

figure;
loglog(a,sqd,'k'); hold on;
xlim([0 1000]); title('Square - diagonal');
xlabel('Filament radius (nm)');
ylabel('Fraction IgG hexamers');
axis square

figure;
loglog(a,squ,'k'); hold on;
xlim([0 1000]); title('Square - upright');
xlabel('Filament radius (nm)');
ylabel('Fraction IgG hexamers');
axis square